﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PayrollSystem
{
    public class BasePlusCommissionEmployee: CommissionEmployee
    {
        private decimal baseSalary; // base salary per week

        ///<summary>six-parameter constructor</summary> 
        public BasePlusCommissionEmployee(string first, string last,
           string ssn, decimal sales, decimal rate, decimal salary):base(first, last, ssn, sales, rate)

        {
            BaseSalary = salary; // validate base salary via property
        } // end six-parameter BasePlusCommissionEmployee constructor

        ///<summary> property that gets and sets 
        ///base-salaried commission employee's base salary
        ///</summary> 
        public decimal BaseSalary
        {
            get
            {
                return baseSalary;
            } // end get
            set
            {
                if (value >= 0)
                    baseSalary = value;
                else
                    throw new ArgumentOutOfRangeException("BaseSalary",
                       value, "BaseSalary must be >= 0");
            } // end set
        } // end property BaseSalary

        ///<summary>calculate earnings; override method Earnings in CommissionEmployee</summary> 
        public override decimal GetPaymentAmount()
        {
            return BaseSalary; //+ base.GetPaymentAmount();
        } // end method Earnings               

        ///<summary>return string representation of BasePlusCommissionEmployee object</summary>
        public override string ToString()
        {
            return string.Format("base-salaried {0}; base salary: {1:C}",
               base.ToString(), BaseSalary);
        } // end method ToString                                            
    } // end class BasePlusCommissionEmployee          
}
